/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.LinkInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Container;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class CalendarDialog
extends AbstractDialog {
    private Date date = null;
    private String text = null;

    public CalendarDialog(int position) {
        super(position);
        this.setTitle(Application.getI18n().tr("Kalender"));
        this.setPanelText("");
    }

    public void setDate(Date d) {
        this.date = d;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        SimpleContainer container = new SimpleContainer(parent);
        if (this.text != null && this.text.length() > 0) {
            container.addText(this.text, true);
        }
        final DateTime cal = new DateTime(((Container)container).getComposite(), 25166848);
        if (this.date != null) {
            Calendar c = Calendar.getInstance(Application.getConfig().getLocale());
            c.setTime(this.date);
            cal.setDate(c.get(1), c.get(2), c.get(5));
        }
        cal.setLayoutData((Object)new GridData(4, 4, true, true));
        cal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CalendarDialog.this.date = CalendarDialog.this.getDateWithoutTime(cal);
                CalendarDialog.this.close();
            }
        });
        LinkInput link = new LinkInput(Application.getI18n().tr("Zum <a>aktuellen Datum</a> wechseln"));
        link.setName("");
        link.addListener(new Listener(){

            public void handleEvent(Event event) {
                Calendar c = Calendar.getInstance(Application.getConfig().getLocale());
                c.setTime(new Date());
                cal.setDate(c.get(1), c.get(2), c.get(5));
            }
        });
        container.addPart(link);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(Application.getI18n().tr("\u00dcbernehmen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                CalendarDialog.this.date = CalendarDialog.this.getDateWithoutTime(cal);
                CalendarDialog.this.close();
            }
        }, null, false, "ok.png");
        buttons.addButton(Application.getI18n().tr("Abbrechen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                CalendarDialog.this.close();
            }
        }, null, false, "process-stop.png");
        container.addButtonArea(buttons);
    }

    protected Object getData() throws Exception {
        return this.date;
    }

    private Date getDateWithoutTime(DateTime cal) {
        Calendar c = Calendar.getInstance();
        c.set(1, cal.getYear());
        c.set(2, cal.getMonth());
        c.set(5, cal.getDay());
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }
}

